/*
 * Decompiled with CFR 0.152.
 */
package org.supercsv.io;

import java.io.IOException;
import java.io.Writer;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.LinkedList;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.io.AbstractCsvWriter;
import org.supercsv.io.ICsvResultSetWriter;
import org.supercsv.prefs.CsvPreference;
import org.supercsv.util.Util;

public class CsvResultSetWriter
extends AbstractCsvWriter
implements ICsvResultSetWriter {
    public CsvResultSetWriter(Writer writer, CsvPreference preference) {
        super(writer, preference);
    }

    public void write(ResultSet resultSet) throws SQLException, IOException {
        if (resultSet == null) {
            throw new NullPointerException("ResultSet cannot be null");
        }
        this.writeHeaders(resultSet);
        this.writeContents(resultSet);
    }

    public void write(ResultSet resultSet, CellProcessor[] writeProcessors) throws SQLException, IOException {
        if (resultSet == null) {
            throw new NullPointerException("ResultSet cannot be null");
        }
        if (writeProcessors == null) {
            throw new NullPointerException("CellProcessor[] cannot be null");
        }
        this.writeHeaders(resultSet);
        this.writeContents(resultSet, writeProcessors);
    }

    private void writeHeaders(ResultSet resultSet) throws SQLException, IOException {
        super.incrementRowAndLineNo();
        ResultSetMetaData meta = resultSet.getMetaData();
        int numberOfColumns = meta.getColumnCount();
        LinkedList<String> headers = new LinkedList<String>();
        for (int columnIndex = 1; columnIndex <= numberOfColumns; ++columnIndex) {
            headers.add(meta.getColumnName(columnIndex));
        }
        super.writeRow(headers);
    }

    private void writeContents(ResultSet resultSet) throws SQLException, IOException {
        int numberOfColumns = resultSet.getMetaData().getColumnCount();
        LinkedList<Object> objects = new LinkedList<Object>();
        while (resultSet.next()) {
            super.incrementRowAndLineNo();
            objects.clear();
            for (int columnIndex = 1; columnIndex <= numberOfColumns; ++columnIndex) {
                objects.add(resultSet.getObject(columnIndex));
            }
            super.writeRow(objects);
        }
    }

    private void writeContents(ResultSet resultSet, CellProcessor[] writeProcessors) throws SQLException, IOException {
        int numberOfColumns = resultSet.getMetaData().getColumnCount();
        LinkedList<Object> objects = new LinkedList<Object>();
        LinkedList<Object> processedColumns = new LinkedList<Object>();
        while (resultSet.next()) {
            super.incrementRowAndLineNo();
            objects.clear();
            for (int columnIndex = 1; columnIndex <= numberOfColumns; ++columnIndex) {
                objects.add(resultSet.getObject(columnIndex));
            }
            Util.executeCellProcessors(processedColumns, objects, writeProcessors, this.getLineNumber(), this.getRowNumber());
            super.writeRow(processedColumns);
        }
    }
}

