/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.Mongo;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.mongodb.core.MongoExceptionTranslator;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class MongoClientFactoryBean
extends AbstractFactoryBean<Mongo>
implements PersistenceExceptionTranslator {
    private static final PersistenceExceptionTranslator DEFAULT_EXCEPTION_TRANSLATOR = new MongoExceptionTranslator();
    private MongoClientOptions mongoClientOptions;
    private String host;
    private Integer port;
    private List<ServerAddress> replicaSetSeeds;
    private List<MongoCredential> credentials;
    private PersistenceExceptionTranslator exceptionTranslator = DEFAULT_EXCEPTION_TRANSLATOR;

    public void setMongoClientOptions(MongoClientOptions mongoClientOptions) {
        this.mongoClientOptions = mongoClientOptions;
    }

    public void setCredentials(MongoCredential[] credentials) {
        this.credentials = MongoClientFactoryBean.filterNonNullElementsAsList(credentials);
    }

    public void setReplicaSetSeeds(ServerAddress[] replicaSetSeeds) {
        this.replicaSetSeeds = MongoClientFactoryBean.filterNonNullElementsAsList(replicaSetSeeds);
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setExceptionTranslator(PersistenceExceptionTranslator exceptionTranslator) {
        this.exceptionTranslator = exceptionTranslator == null ? DEFAULT_EXCEPTION_TRANSLATOR : exceptionTranslator;
    }

    public Class<? extends Mongo> getObjectType() {
        return Mongo.class;
    }

    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        return this.exceptionTranslator.translateExceptionIfPossible(ex);
    }

    protected Mongo createInstance() throws Exception {
        if (this.mongoClientOptions == null) {
            this.mongoClientOptions = MongoClientOptions.builder().build();
        }
        if (this.credentials == null) {
            this.credentials = Collections.emptyList();
        }
        return this.createMongoClient();
    }

    protected void destroyInstance(Mongo instance) throws Exception {
        instance.close();
    }

    private MongoClient createMongoClient() throws UnknownHostException {
        if (!CollectionUtils.isEmpty(this.replicaSetSeeds)) {
            return new MongoClient(this.replicaSetSeeds, this.credentials, this.mongoClientOptions);
        }
        return new MongoClient(this.createConfiguredOrDefaultServerAddress(), this.credentials, this.mongoClientOptions);
    }

    private ServerAddress createConfiguredOrDefaultServerAddress() throws UnknownHostException {
        ServerAddress defaultAddress = new ServerAddress();
        return new ServerAddress(StringUtils.hasText((String)this.host) ? this.host : defaultAddress.getHost(), this.port != null ? this.port.intValue() : defaultAddress.getPort());
    }

    private static <T> List<T> filterNonNullElementsAsList(T[] elements) {
        if (elements == null) {
            return Collections.emptyList();
        }
        ArrayList<T> candidateElements = new ArrayList<T>();
        for (T element : elements) {
            if (element == null) continue;
            candidateElements.add(element);
        }
        return Collections.unmodifiableList(candidateElements);
    }
}

