/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.mapping;

import com.mongodb.DBObject;
import com.mongodb.DBRef;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import org.bson.types.Binary;
import org.bson.types.CodeWScope;
import org.bson.types.ObjectId;
import org.springframework.data.mapping.model.SimpleTypeHolder;

public abstract class MongoSimpleTypes {
    public static final Set<Class<?>> AUTOGENERATED_ID_TYPES;
    private static final Set<Class<?>> MONGO_SIMPLE_TYPES;
    public static final SimpleTypeHolder HOLDER;

    private MongoSimpleTypes() {
    }

    static {
        HashSet<Class<BigInteger>> classes = new HashSet<Class<BigInteger>>();
        classes.add(ObjectId.class);
        classes.add(String.class);
        classes.add(BigInteger.class);
        AUTOGENERATED_ID_TYPES = Collections.unmodifiableSet(classes);
        HashSet<Class<UUID>> simpleTypes = new HashSet<Class<UUID>>();
        simpleTypes.add(DBRef.class);
        simpleTypes.add(ObjectId.class);
        simpleTypes.add(CodeWScope.class);
        simpleTypes.add(DBObject.class);
        simpleTypes.add(Pattern.class);
        simpleTypes.add(Binary.class);
        simpleTypes.add(UUID.class);
        MONGO_SIMPLE_TYPES = Collections.unmodifiableSet(simpleTypes);
        HOLDER = new SimpleTypeHolder(MONGO_SIMPLE_TYPES, true);
    }
}

