/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.query;

import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.EntityInstantiators;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.repository.query.ConvertingParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoParametersParameterAccessor;
import org.springframework.data.mongodb.repository.query.MongoQueryExecution;
import org.springframework.data.mongodb.repository.query.MongoQueryMethod;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.util.Assert;

public abstract class AbstractMongoQuery
implements RepositoryQuery {
    private final MongoQueryMethod method;
    private final MongoOperations operations;
    private final EntityInstantiators instantiators;

    public AbstractMongoQuery(MongoQueryMethod method, MongoOperations operations) {
        Assert.notNull((Object)operations, (String)"MongoOperations must not be null!");
        Assert.notNull((Object)((Object)method), (String)"MongoQueryMethod must not be null!");
        this.method = method;
        this.operations = operations;
        this.instantiators = new EntityInstantiators();
    }

    public MongoQueryMethod getQueryMethod() {
        return this.method;
    }

    public Object execute(Object[] parameters) {
        MongoParametersParameterAccessor accessor = new MongoParametersParameterAccessor(this.method, parameters);
        Query query = this.createQuery(new ConvertingParameterAccessor(this.operations.getConverter(), accessor));
        this.applyQueryMetaAttributesWhenPresent(query);
        ResultProcessor processor = this.method.getResultProcessor().withDynamicProjection((ParameterAccessor)accessor);
        String collection = this.method.getEntityInformation().getCollectionName();
        MongoQueryExecution execution = this.getExecution(query, accessor, new MongoQueryExecution.ResultProcessingConverter(processor, this.operations, this.instantiators));
        return execution.execute(query, processor.getReturnedType().getDomainType(), collection);
    }

    private MongoQueryExecution getExecution(Query query, MongoParameterAccessor accessor, Converter<Object, Object> resultProcessing) {
        if (this.method.isStreamQuery()) {
            return new MongoQueryExecution.StreamExecution(this.operations, resultProcessing);
        }
        return new MongoQueryExecution.ResultProcessingExecution(this.getExecutionToWrap(query, accessor), resultProcessing);
    }

    private MongoQueryExecution getExecutionToWrap(Query query, MongoParameterAccessor accessor) {
        if (this.isDeleteQuery()) {
            return new MongoQueryExecution.DeleteExecution(this.operations, this.method);
        }
        if (this.method.isGeoNearQuery() && this.method.isPageQuery()) {
            return new MongoQueryExecution.PagingGeoNearExecution(this.operations, accessor, this.method.getReturnType(), this);
        }
        if (this.method.isGeoNearQuery()) {
            return new MongoQueryExecution.GeoNearExecution(this.operations, accessor, this.method.getReturnType());
        }
        if (this.method.isSliceQuery()) {
            return new MongoQueryExecution.SlicedExecution(this.operations, accessor.getPageable());
        }
        if (this.method.isCollectionQuery()) {
            return new MongoQueryExecution.CollectionExecution(this.operations, accessor.getPageable());
        }
        if (this.method.isPageQuery()) {
            return new MongoQueryExecution.PagedExecution(this.operations, accessor.getPageable());
        }
        return new MongoQueryExecution.SingleEntityExecution(this.operations, this.isCountQuery());
    }

    Query applyQueryMetaAttributesWhenPresent(Query query) {
        if (this.method.hasQueryMetaAttributes()) {
            query.setMeta(this.method.getQueryMetaAttributes());
        }
        return query;
    }

    protected Query createCountQuery(ConvertingParameterAccessor accessor) {
        return this.applyQueryMetaAttributesWhenPresent(this.createQuery(accessor));
    }

    protected abstract Query createQuery(ConvertingParameterAccessor var1);

    protected abstract boolean isCountQuery();

    protected abstract boolean isDeleteQuery();
}

