/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.http.converter.jaxb;

import java.io.IOException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.MarshalException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import org.springframework.http.HttpHeaders;
import org.springframework.http.converter.HttpMessageConversionException;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.http.converter.xml.AbstractXmlHttpMessageConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractJaxbMessageConverter<I, E>
extends AbstractXmlHttpMessageConverter<E> {
    private final Class<I> internalClass;
    private final Class<E> externalClass;
    private final JAXBContext context;

    public AbstractJaxbMessageConverter(Class<I> internalClass, Class<E> externalClass) {
        this.internalClass = internalClass;
        this.externalClass = externalClass;
        try {
            this.context = JAXBContext.newInstance((Class[])new Class[]{this.internalClass});
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    protected final E readFromSource(Class<? extends E> clazz, HttpHeaders headers, Source source) throws IOException {
        try {
            JAXBElement jaxbElement = this.createUnmarshaller().unmarshal(source, this.internalClass);
            return this.convertToExternal(jaxbElement.getValue());
        }
        catch (UnmarshalException ex) {
            throw new HttpMessageNotReadableException("Could not unmarshal to [" + clazz + "]: " + ex.getMessage(), (Throwable)ex);
        }
        catch (JAXBException ex) {
            throw new HttpMessageConversionException("Could not instantiate JAXBContext: " + ex.getMessage(), (Throwable)ex);
        }
    }

    protected final void writeToResult(E accessToken, HttpHeaders headers, Result result) throws IOException {
        I convertedAccessToken = this.convertToInternal(accessToken);
        try {
            this.createMarshaller().marshal(convertedAccessToken, result);
        }
        catch (MarshalException ex) {
            throw new HttpMessageNotWritableException("Could not marshal [" + accessToken + "]: " + ex.getMessage(), (Throwable)ex);
        }
        catch (JAXBException ex) {
            throw new HttpMessageConversionException("Could not instantiate JAXBContext: " + ex.getMessage(), (Throwable)ex);
        }
    }

    protected final boolean supports(Class<?> clazz) {
        return this.externalClass.isAssignableFrom(clazz);
    }

    protected abstract E convertToExternal(I var1);

    protected abstract I convertToInternal(E var1);

    private Unmarshaller createUnmarshaller() throws JAXBException {
        return this.context.createUnmarshaller();
    }

    private Marshaller createMarshaller() throws JAXBException {
        Marshaller marshaller = this.context.createMarshaller();
        marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
        return marshaller;
    }
}

