/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider;

import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.provider.AuthorizationRequest;

public class OAuth2Authentication
extends AbstractAuthenticationToken {
    private static final long serialVersionUID = -4809832298438307309L;
    private final AuthorizationRequest clientAuthentication;
    private final Authentication userAuthentication;

    public OAuth2Authentication(AuthorizationRequest authorizationRequest, Authentication userAuthentication) {
        super(userAuthentication == null ? authorizationRequest.getAuthorities() : userAuthentication.getAuthorities());
        this.clientAuthentication = authorizationRequest;
        this.userAuthentication = userAuthentication;
    }

    public Object getCredentials() {
        return "";
    }

    public Object getPrincipal() {
        return this.userAuthentication == null ? this.clientAuthentication.getClientId() : this.userAuthentication.getPrincipal();
    }

    public boolean isClientOnly() {
        return this.userAuthentication == null;
    }

    public AuthorizationRequest getAuthorizationRequest() {
        return this.clientAuthentication;
    }

    public Authentication getUserAuthentication() {
        return this.userAuthentication;
    }

    public boolean isAuthenticated() {
        return this.clientAuthentication.isApproved() && (this.userAuthentication == null || this.userAuthentication.isAuthenticated());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OAuth2Authentication)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OAuth2Authentication that = (OAuth2Authentication)((Object)o);
        if (!this.clientAuthentication.equals(that.clientAuthentication)) {
            return false;
        }
        return !(this.userAuthentication != null ? !this.userAuthentication.equals(that.userAuthentication) : that.userAuthentication != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.clientAuthentication.hashCode();
        result = 31 * result + (this.userAuthentication != null ? this.userAuthentication.hashCode() : 0);
        return result;
    }
}

