/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.context.support;

import java.util.Enumeration;
import javax.servlet.ServletContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public abstract class SecurityWebApplicationContextUtils
extends WebApplicationContextUtils {
    public static WebApplicationContext findRequiredWebApplicationContext(ServletContext servletContext) {
        WebApplicationContext wac = SecurityWebApplicationContextUtils.findWebApplicationContext(servletContext);
        if (wac == null) {
            throw new IllegalStateException("No WebApplicationContext found: no ContextLoaderListener registered?");
        }
        return wac;
    }

    private static WebApplicationContext findWebApplicationContext(ServletContext sc) {
        WebApplicationContext wac = SecurityWebApplicationContextUtils.getWebApplicationContext((ServletContext)sc);
        if (wac == null) {
            Enumeration attrNames = sc.getAttributeNames();
            while (attrNames.hasMoreElements()) {
                String attrName = (String)attrNames.nextElement();
                Object attrValue = sc.getAttribute(attrName);
                if (!(attrValue instanceof WebApplicationContext)) continue;
                if (wac != null) {
                    throw new IllegalStateException("No unique WebApplicationContext found: more than one DispatcherServlet registered with publishContext=true?");
                }
                wac = (WebApplicationContext)attrValue;
            }
        }
        return wac;
    }
}

