/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.release;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Profile;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.release.ReleaseManager;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.env.DefaultReleaseEnvironment;
import org.apache.maven.shared.release.env.ReleaseEnvironment;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractReleaseMojo
extends AbstractMojo {
    private String username;
    private String password;
    private String tag;
    private String tagNameFormat;
    private String tagBase;
    private File basedir;
    private Settings settings;
    protected MavenProject project;
    protected ReleaseManager releaseManager;
    private String arguments;
    private String pomFileName;
    private String scmCommentPrefix;
    private List<MavenProject> reactorProjects;
    private Map<String, String> providerImplementations;
    protected File mavenHome;
    private File javaHome;
    private File localRepoDirectory;
    private String mavenExecutorId;
    private boolean localCheckout;
    private boolean pushChanges = true;
    private ScmManager scmManager;
    protected MavenSession session;

    protected ReleaseEnvironment getReleaseEnvironment() {
        return new DefaultReleaseEnvironment().setSettings(this.settings).setJavaHome(this.javaHome).setMavenHome(this.mavenHome).setLocalRepositoryDirectory(this.localRepoDirectory).setMavenExecutorId(this.mavenExecutorId);
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.providerImplementations != null) {
            for (Map.Entry<String, String> providerEntry : this.providerImplementations.entrySet()) {
                this.getLog().info((CharSequence)("Change the default '" + providerEntry.getKey() + "' provider implementation to '" + providerEntry.getValue() + "'."));
                this.scmManager.setScmProviderImplementation(providerEntry.getKey(), providerEntry.getValue());
            }
        }
    }

    protected ReleaseDescriptor createReleaseDescriptor() {
        ReleaseDescriptor descriptor = new ReleaseDescriptor();
        descriptor.setInteractive(this.settings.isInteractiveMode());
        descriptor.setScmPassword(this.password);
        descriptor.setScmReleaseLabel(this.tag);
        descriptor.setScmTagNameFormat(this.tagNameFormat);
        descriptor.setScmTagBase(this.tagBase);
        descriptor.setScmUsername(this.username);
        descriptor.setScmCommentPrefix(this.scmCommentPrefix);
        descriptor.setWorkingDirectory(this.basedir.getAbsolutePath());
        descriptor.setPomFileName(this.pomFileName);
        descriptor.setLocalCheckout(this.localCheckout);
        descriptor.setPushChanges(this.pushChanges);
        List profiles = this.project.getActiveProfiles();
        String arguments = this.arguments;
        if (profiles != null && !profiles.isEmpty()) {
            arguments = !StringUtils.isEmpty((String)arguments) ? arguments + " -P " : "-P ";
            Iterator it = profiles.iterator();
            while (it.hasNext()) {
                Profile profile = (Profile)it.next();
                arguments = arguments + profile.getId();
                if (!it.hasNext()) continue;
                arguments = arguments + ",";
            }
            String additionalProfiles = this.getAdditionalProfiles();
            if (additionalProfiles != null) {
                if (!profiles.isEmpty()) {
                    arguments = arguments + ",";
                }
                arguments = arguments + additionalProfiles;
            }
        }
        descriptor.setAdditionalArguments(arguments);
        return descriptor;
    }

    protected String getAdditionalProfiles() {
        return null;
    }

    void setReleaseManager(ReleaseManager releaseManager) {
        this.releaseManager = releaseManager;
    }

    Settings getSettings() {
        return this.settings;
    }

    protected final File getBasedir() {
        return this.basedir;
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public List<MavenProject> getReactorProjects() {
        return this.reactorProjects;
    }

    protected void addArgument(String argument) {
        this.arguments = this.arguments != null ? this.arguments + " " + argument : argument;
    }

    protected void mergeCommandLineConfig(ReleaseDescriptor config, ReleaseDescriptor sysPropertiesConfig) {
        if (sysPropertiesConfig.getReleaseVersions() != null) {
            config.getReleaseVersions().putAll(sysPropertiesConfig.getReleaseVersions());
        }
        if (sysPropertiesConfig.getDevelopmentVersions() != null) {
            config.getDevelopmentVersions().putAll(sysPropertiesConfig.getDevelopmentVersions());
        }
    }
}

