/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.buildpack.platform.docker.type;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.boot.buildpack.platform.docker.type.ImageName;
import org.springframework.boot.buildpack.platform.docker.type.RandomString;
import org.springframework.boot.buildpack.platform.docker.type.Regex;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public final class ImageReference {
    private static final Pattern PATTERN = Regex.IMAGE_REFERENCE.compile();
    private static final Pattern JAR_VERSION_PATTERN = Pattern.compile("^(.*)(\\-\\d+)$");
    private static final String LATEST = "latest";
    private final ImageName name;
    private final String tag;
    private final String digest;
    private final String string;

    private ImageReference(ImageName name, String tag, String digest) {
        Assert.notNull((Object)name, (String)"Name must not be null");
        this.name = name;
        this.tag = tag;
        this.digest = digest;
        this.string = this.buildString(name.toString(), tag, digest);
    }

    public String getDomain() {
        return this.name.getDomain();
    }

    public String getName() {
        return this.name.getName();
    }

    public String getTag() {
        return this.tag;
    }

    public String getDigest() {
        return this.digest;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ImageReference other = (ImageReference)obj;
        boolean result = true;
        result = result && this.name.equals(other.name);
        result = result && ObjectUtils.nullSafeEquals((Object)this.tag, (Object)other.tag);
        result = result && ObjectUtils.nullSafeEquals((Object)this.digest, (Object)other.digest);
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.tag);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.digest);
        return result;
    }

    public String toString() {
        return this.string;
    }

    public String toLegacyString() {
        return this.buildString(this.name.toLegacyString(), this.tag, this.digest);
    }

    private String buildString(String name, String tag, String digest) {
        StringBuilder string = new StringBuilder(name);
        if (tag != null) {
            string.append(":").append(tag);
        }
        if (digest != null) {
            string.append("@").append(digest);
        }
        return string.toString();
    }

    public ImageReference withDigest(String digest) {
        return new ImageReference(this.name, null, digest);
    }

    public ImageReference inTaggedForm() {
        Assert.state((this.digest == null ? 1 : 0) != 0, () -> "Image reference '" + this + "' cannot contain a digest");
        return new ImageReference(this.name, this.tag != null ? this.tag : LATEST, null);
    }

    public ImageReference inTaggedOrDigestForm() {
        if (this.digest != null) {
            return this;
        }
        return this.inTaggedForm();
    }

    public static ImageReference forJarFile(File jarFile) {
        String filename = jarFile.getName();
        Assert.isTrue((boolean)filename.toLowerCase().endsWith(".jar"), () -> "File '" + jarFile + "' is not a JAR");
        filename = filename.substring(0, filename.length() - 4);
        int firstDot = filename.indexOf(46);
        if (firstDot == -1) {
            return ImageReference.of(filename);
        }
        String name = filename.substring(0, firstDot);
        String version = filename.substring(firstDot + 1);
        Matcher matcher = JAR_VERSION_PATTERN.matcher(name);
        if (matcher.matches()) {
            name = matcher.group(1);
            version = matcher.group(2).substring(1) + "." + version;
        }
        return ImageReference.of(ImageName.of(name), version);
    }

    public static ImageReference random(String prefix) {
        return ImageReference.random(prefix, 10);
    }

    public static ImageReference random(String prefix, int randomLength) {
        return ImageReference.of(RandomString.generate(prefix, randomLength));
    }

    public static ImageReference of(String value) {
        Assert.hasText((String)value, (String)"Value must not be null");
        Matcher matcher = PATTERN.matcher(value);
        Assert.isTrue((boolean)matcher.matches(), () -> "Unable to parse image reference \"" + value + "\". Image reference must be in the form '[domainHost:port/][path/]name[:tag][@digest]', with 'path' and 'name' containing only [a-z0-9][.][_][-]");
        ImageName name = new ImageName(matcher.group("domain"), matcher.group("path"));
        return new ImageReference(name, matcher.group("tag"), matcher.group("digest"));
    }

    public static ImageReference of(ImageName name) {
        return new ImageReference(name, null, null);
    }

    public static ImageReference of(ImageName name, String tag) {
        return new ImageReference(name, tag, null);
    }

    public static ImageReference of(ImageName name, String tag, String digest) {
        return new ImageReference(name, tag, digest);
    }
}

