/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.CommandResult;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.ReadPreference;
import com.mongodb.WriteResult;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.mongodb.core.BulkOperations;
import org.springframework.data.mongodb.core.CollectionCallback;
import org.springframework.data.mongodb.core.CollectionOptions;
import org.springframework.data.mongodb.core.DbCallback;
import org.springframework.data.mongodb.core.DocumentCallbackHandler;
import org.springframework.data.mongodb.core.FindAndModifyOptions;
import org.springframework.data.mongodb.core.IndexOperations;
import org.springframework.data.mongodb.core.ScriptOperations;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationResults;
import org.springframework.data.mongodb.core.aggregation.TypedAggregation;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.mapreduce.GroupBy;
import org.springframework.data.mongodb.core.mapreduce.GroupByResults;
import org.springframework.data.mongodb.core.mapreduce.MapReduceOptions;
import org.springframework.data.mongodb.core.mapreduce.MapReduceResults;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.NearQuery;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.util.CloseableIterator;

public interface MongoOperations {
    public String getCollectionName(Class<?> var1);

    public CommandResult executeCommand(String var1);

    public CommandResult executeCommand(DBObject var1);

    @Deprecated
    public CommandResult executeCommand(DBObject var1, int var2);

    public CommandResult executeCommand(DBObject var1, ReadPreference var2);

    public void executeQuery(Query var1, String var2, DocumentCallbackHandler var3);

    public <T> T execute(DbCallback<T> var1);

    public <T> T execute(Class<?> var1, CollectionCallback<T> var2);

    public <T> T execute(String var1, CollectionCallback<T> var2);

    @Deprecated
    public <T> T executeInSession(DbCallback<T> var1);

    public <T> CloseableIterator<T> stream(Query var1, Class<T> var2);

    public <T> DBCollection createCollection(Class<T> var1);

    public <T> DBCollection createCollection(Class<T> var1, CollectionOptions var2);

    public DBCollection createCollection(String var1);

    public DBCollection createCollection(String var1, CollectionOptions var2);

    public Set<String> getCollectionNames();

    public DBCollection getCollection(String var1);

    public <T> boolean collectionExists(Class<T> var1);

    public boolean collectionExists(String var1);

    public <T> void dropCollection(Class<T> var1);

    public void dropCollection(String var1);

    public IndexOperations indexOps(String var1);

    public IndexOperations indexOps(Class<?> var1);

    public ScriptOperations scriptOps();

    public BulkOperations bulkOps(BulkOperations.BulkMode var1, String var2);

    public BulkOperations bulkOps(BulkOperations.BulkMode var1, Class<?> var2);

    public BulkOperations bulkOps(BulkOperations.BulkMode var1, Class<?> var2, String var3);

    public <T> List<T> findAll(Class<T> var1);

    public <T> List<T> findAll(Class<T> var1, String var2);

    public <T> GroupByResults<T> group(String var1, GroupBy var2, Class<T> var3);

    public <T> GroupByResults<T> group(Criteria var1, String var2, GroupBy var3, Class<T> var4);

    public <O> AggregationResults<O> aggregate(TypedAggregation<?> var1, String var2, Class<O> var3);

    public <O> AggregationResults<O> aggregate(TypedAggregation<?> var1, Class<O> var2);

    public <O> AggregationResults<O> aggregate(Aggregation var1, Class<?> var2, Class<O> var3);

    public <O> AggregationResults<O> aggregate(Aggregation var1, String var2, Class<O> var3);

    public <T> MapReduceResults<T> mapReduce(String var1, String var2, String var3, Class<T> var4);

    public <T> MapReduceResults<T> mapReduce(String var1, String var2, String var3, MapReduceOptions var4, Class<T> var5);

    public <T> MapReduceResults<T> mapReduce(Query var1, String var2, String var3, String var4, Class<T> var5);

    public <T> MapReduceResults<T> mapReduce(Query var1, String var2, String var3, String var4, MapReduceOptions var5, Class<T> var6);

    public <T> GeoResults<T> geoNear(NearQuery var1, Class<T> var2);

    public <T> GeoResults<T> geoNear(NearQuery var1, Class<T> var2, String var3);

    public <T> T findOne(Query var1, Class<T> var2);

    public <T> T findOne(Query var1, Class<T> var2, String var3);

    public boolean exists(Query var1, String var2);

    public boolean exists(Query var1, Class<?> var2);

    public boolean exists(Query var1, Class<?> var2, String var3);

    public <T> List<T> find(Query var1, Class<T> var2);

    public <T> List<T> find(Query var1, Class<T> var2, String var3);

    public <T> T findById(Object var1, Class<T> var2);

    public <T> T findById(Object var1, Class<T> var2, String var3);

    public <T> T findAndModify(Query var1, Update var2, Class<T> var3);

    public <T> T findAndModify(Query var1, Update var2, Class<T> var3, String var4);

    public <T> T findAndModify(Query var1, Update var2, FindAndModifyOptions var3, Class<T> var4);

    public <T> T findAndModify(Query var1, Update var2, FindAndModifyOptions var3, Class<T> var4, String var5);

    public <T> T findAndRemove(Query var1, Class<T> var2);

    public <T> T findAndRemove(Query var1, Class<T> var2, String var3);

    public long count(Query var1, Class<?> var2);

    public long count(Query var1, String var2);

    public long count(Query var1, Class<?> var2, String var3);

    public void insert(Object var1);

    public void insert(Object var1, String var2);

    public void insert(Collection<? extends Object> var1, Class<?> var2);

    public void insert(Collection<? extends Object> var1, String var2);

    public void insertAll(Collection<? extends Object> var1);

    public void save(Object var1);

    public void save(Object var1, String var2);

    public WriteResult upsert(Query var1, Update var2, Class<?> var3);

    public WriteResult upsert(Query var1, Update var2, String var3);

    public WriteResult upsert(Query var1, Update var2, Class<?> var3, String var4);

    public WriteResult updateFirst(Query var1, Update var2, Class<?> var3);

    public WriteResult updateFirst(Query var1, Update var2, String var3);

    public WriteResult updateFirst(Query var1, Update var2, Class<?> var3, String var4);

    public WriteResult updateMulti(Query var1, Update var2, Class<?> var3);

    public WriteResult updateMulti(Query var1, Update var2, String var3);

    public WriteResult updateMulti(Query var1, Update var2, Class<?> var3, String var4);

    public WriteResult remove(Object var1);

    public WriteResult remove(Object var1, String var2);

    public WriteResult remove(Query var1, Class<?> var2);

    public WriteResult remove(Query var1, Class<?> var2, String var3);

    public WriteResult remove(Query var1, String var2);

    public <T> List<T> findAllAndRemove(Query var1, String var2);

    public <T> List<T> findAllAndRemove(Query var1, Class<T> var2);

    public <T> List<T> findAllAndRemove(Query var1, Class<T> var2, String var3);

    public MongoConverter getConverter();
}

