/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.plugin.cli;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandContextFactory;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.batch.Batch;
import org.jboss.as.cli.batch.BatchManager;
import org.jboss.dmr.ModelNode;
import org.wildfly.plugin.cli.Commands;
import org.wildfly.plugin.cli.ModuleEnvironment;
import org.wildfly.plugin.common.MavenModelControllerClientConfiguration;
import org.wildfly.plugin.common.ServerOperations;

@Named
@Singleton
public class CommandExecutor {
    private static final String WILDFLY_CONFIG_KEY = "wildfly.config.url";

    public void execute(MavenModelControllerClientConfiguration configuration, Commands commands) throws IOException {
        this.execute(configuration, (Path)null, commands);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(MavenModelControllerClientConfiguration configuration, Path wildflyHome, Commands commands) throws IOException {
        if (wildflyHome != null) {
            try {
                System.setProperty("jboss.home.dir", wildflyHome.toString());
                this.executeCommands(configuration, commands);
            }
            finally {
                System.clearProperty("jboss.home.dir");
            }
        } else {
            this.executeCommands(configuration, commands);
        }
    }

    public void execute(MavenModelControllerClientConfiguration configuration, String wildflyHome, Commands commands) throws IOException {
        Path path = null;
        if (wildflyHome != null) {
            path = Paths.get(wildflyHome, new String[0]);
        }
        this.execute(configuration, path, commands);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCommands(MavenModelControllerClientConfiguration configuration, Commands commands) throws IOException {
        if (commands.hasCommands() || commands.hasScripts()) {
            try {
                ModuleEnvironment.initJaxp();
                String currentWildFlyConfUrl = System.getProperty(WILDFLY_CONFIG_KEY);
                if (configuration.getAuthenticationConfigUri() != null) {
                    System.setProperty(WILDFLY_CONFIG_KEY, configuration.getAuthenticationConfigUri().toString());
                }
                CommandContext ctx = this.create(configuration);
                try {
                    if (commands.isBatch()) {
                        CommandExecutor.executeBatch(ctx, commands.getCommands());
                    } else {
                        CommandExecutor.executeCommands(ctx, commands.getCommands(), commands.isFailOnError());
                    }
                    CommandExecutor.executeScripts(ctx, commands.getScripts(), commands.isFailOnError());
                }
                finally {
                    if (currentWildFlyConfUrl == null) {
                        System.clearProperty(WILDFLY_CONFIG_KEY);
                    } else {
                        System.setProperty(WILDFLY_CONFIG_KEY, currentWildFlyConfUrl);
                    }
                    ctx.terminateSession();
                    ctx.bindClient(null);
                }
            }
            finally {
                ModuleEnvironment.restorePlatform();
            }
        }
    }

    private static void executeScripts(CommandContext ctx, Iterable<File> scripts, boolean failOnError) {
        for (File script : scripts) {
            try {
                CommandExecutor.executeCommands(ctx, Files.readAllLines(script.toPath(), StandardCharsets.UTF_8), failOnError);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to process file '" + script.getAbsolutePath() + "'", e);
            }
        }
    }

    private static void executeCommands(CommandContext ctx, Iterable<String> commands, boolean failOnError) {
        for (String cmd : commands) {
            try {
                if (failOnError) {
                    ctx.handle(cmd);
                    continue;
                }
                ctx.handleSafe(cmd);
            }
            catch (CommandFormatException e) {
                throw new IllegalArgumentException(String.format("Command '%s' is invalid. %s", cmd, e.getLocalizedMessage()), e);
            }
            catch (CommandLineException e) {
                throw new IllegalArgumentException(String.format("Command execution failed for command '%s'. %s", cmd, e.getLocalizedMessage()), e);
            }
        }
    }

    private static void executeBatch(CommandContext ctx, Iterable<String> commands) throws IOException {
        BatchManager batchManager = ctx.getBatchManager();
        if (batchManager.activateNewBatch()) {
            Batch batch = batchManager.getActiveBatch();
            for (String cmd : commands) {
                try {
                    batch.add(ctx.toBatchedCommand(cmd));
                }
                catch (CommandFormatException e) {
                    throw new IllegalArgumentException(String.format("Command '%s' is invalid. %s", cmd, e.getLocalizedMessage()), e);
                }
            }
            ModelNode result = ctx.getModelControllerClient().execute(batch.toRequest());
            if (!ServerOperations.isSuccessfulOutcome((ModelNode)result)) {
                throw new IllegalArgumentException(ServerOperations.getFailureDescriptionAsString(result));
            }
        }
    }

    private CommandContext create(MavenModelControllerClientConfiguration configuration) {
        CommandContext commandContext = null;
        try {
            commandContext = CommandContextFactory.getInstance().newCommandContext(configuration.getController(), configuration.getUsername(), configuration.getPassword(), (InputStream)new UncloseableInputStream(System.in), (OutputStream)new UncloseableOutputStream(System.out));
            commandContext.connectController();
        }
        catch (CommandLineException e) {
            if (commandContext != null) {
                commandContext.terminateSession();
            }
            throw new IllegalStateException("Failed to initialize CLI context", e);
        }
        return commandContext;
    }

    private static class UncloseableOutputStream
    extends OutputStream {
        private final OutputStream delegate;

        private UncloseableOutputStream(OutputStream delegate) {
            this.delegate = delegate;
        }

        @Override
        public void write(int b) throws IOException {
            this.delegate.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.delegate.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.delegate.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.delegate.flush();
        }

        @Override
        public void close() throws IOException {
        }
    }

    private static class UncloseableInputStream
    extends InputStream {
        private final InputStream delegate;

        private UncloseableInputStream(InputStream delegate) {
            this.delegate = delegate;
        }

        @Override
        public int read() throws IOException {
            return this.delegate.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.delegate.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.delegate.read(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            return this.delegate.skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.delegate.available();
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void mark(int readlimit) {
            this.delegate.mark(readlimit);
        }

        @Override
        public void reset() throws IOException {
            this.delegate.reset();
        }

        @Override
        public boolean markSupported() {
            return this.delegate.markSupported();
        }
    }
}

